/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.mixin.TemplateAccessor;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.features.configs.NbtDungeonConfig;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SpawnerBlock;
import net.minecraft.entity.EntityType;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.ChestType;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.ProcessorLists;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class NbtDungeon
extends Feature<NbtDungeonConfig> {
    public NbtDungeon(Codec<NbtDungeonConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(ISeedReader world, ChunkGenerator chunkGenerator, Random random, BlockPos position, NbtDungeonConfig config) {
        if (GeneralUtils.isBlacklistedForWorld(world, config.cfID)) {
            return false;
        }
        ResourceLocation nbtRL = (ResourceLocation)GeneralUtils.getRandomEntry(config.nbtResourcelocationsAndWeights, random);
        TemplateManager structureManager = world.func_201672_e().func_184163_y();
        Template template = structureManager.func_200219_b(nbtRL);
        if (template == null) {
            RepurposedStructures.LOGGER.error("Identifier to the specified nbt file was not found! : {}", (Object)nbtRL);
            return false;
        }
        Rotation rotation = Rotation.func_222466_a((Random)random);
        BlockPos halfLengths = new BlockPos(template.func_186259_a().func_177958_n() / 2, template.func_186259_a().func_177956_o() / 2, template.func_186259_a().func_177952_p() / 2);
        BlockPos fullLengths = new BlockPos(Math.abs(template.func_186259_a().func_190942_a(rotation).func_177958_n()), Math.abs(template.func_186259_a().func_190942_a(rotation).func_177956_o()), Math.abs(template.func_186259_a().func_190942_a(rotation).func_177952_p()));
        BlockPos halfLengthsRotated = new BlockPos(fullLengths.func_177958_n() / 2, fullLengths.func_177956_o() / 2, fullLengths.func_177952_p() / 2);
        BlockPos.Mutable mutable = new BlockPos.Mutable().func_189533_g((Vector3i)position);
        IChunk cachedChunk = world.func_217349_x((BlockPos)mutable);
        int xMin = -halfLengthsRotated.func_177958_n();
        int xMax = halfLengthsRotated.func_177958_n();
        int zMin = -halfLengthsRotated.func_177952_p();
        int zMax = halfLengthsRotated.func_177952_p();
        int wallOpenings = 0;
        int ceilingOpenings = 0;
        int ceiling = template.func_186259_a().func_177956_o();
        for (int x = xMin; x <= xMax; ++x) {
            for (int z = zMin; z <= zMax; ++z) {
                for (int y = 0; y <= ceiling; ++y) {
                    mutable.func_189533_g((Vector3i)position).func_196234_d(x, y, z);
                    if (mutable.func_177958_n() >> 4 != cachedChunk.func_76632_l().field_77276_a || mutable.func_177952_p() >> 4 != cachedChunk.func_76632_l().field_77275_b) {
                        cachedChunk = world.func_217349_x((BlockPos)mutable);
                    }
                    BlockState state = cachedChunk.func_180495_p((BlockPos)mutable);
                    if (config.airRequirementIsNowWater ? state.func_196958_f() || state.func_204520_s().func_206884_a((ITag)FluidTags.field_206960_b) : !state.func_204520_s().func_206888_e()) {
                        return false;
                    }
                    if (!GeneralUtils.isFullCube((IWorldReader)world, (BlockPos)mutable, state)) {
                        if (y == 0 && !state.func_185904_a().func_76220_a()) {
                            return false;
                        }
                        if (state.func_235714_a_((ITag)BlockTags.field_206952_E)) continue;
                        if (y == ceiling) {
                            ++ceilingOpenings;
                        }
                    }
                    if ((x == xMin || x == xMax || z == zMin || z == zMax) && y == 1 && this.isValidNonSolidBlock(config, state)) {
                        BlockState aboveState = cachedChunk.func_180495_p((BlockPos)mutable);
                        if (config.airRequirementIsNowWater ? !aboveState.func_204520_s().func_206888_e() : aboveState.func_196958_f()) {
                            ++wallOpenings;
                        }
                    }
                    if (wallOpenings <= config.maxAirSpace && ceilingOpenings <= config.maxAirSpace) continue;
                    return false;
                }
            }
        }
        if (wallOpenings >= config.minAirSpace) {
            position = position.func_177981_b(config.structureYOffset);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(rotation).func_207665_a(halfLengths).func_186222_a(false);
            Optional processor = world.func_201672_e().func_73046_m().func_244267_aX().func_243612_b(Registry.field_243554_aw).func_241873_b(config.processor);
            processor.orElse(ProcessorLists.field_244101_a).func_242919_a().forEach(arg_0 -> ((PlacementSettings)placementsettings).func_215222_a(arg_0));
            template.func_237144_a_((IServerWorld)world, (BlockPos)mutable.func_189533_g((Vector3i)position).func_196234_d(-halfLengths.func_177958_n(), 0, -halfLengths.func_177952_p()), placementsettings, random);
            placementsettings.func_215219_b();
            Optional postProcessor = world.func_201672_e().func_73046_m().func_244267_aX().func_243612_b(Registry.field_243554_aw).func_241873_b(config.postProcessor);
            postProcessor.orElse(ProcessorLists.field_244101_a).func_242919_a().forEach(arg_0 -> ((PlacementSettings)placementsettings).func_215222_a(arg_0));
            List list = placementsettings.func_237132_a_(((TemplateAccessor)template).repurposedstructures_getBlocks(), (BlockPos)mutable).func_237157_a_();
            Template.func_237145_a_((IWorld)world, (BlockPos)mutable, (BlockPos)mutable, (PlacementSettings)placementsettings, (List)list);
            this.spawnLootBlocks(world, random, position, config, fullLengths, halfLengthsRotated, mutable);
            return true;
        }
        return false;
    }

    private boolean isValidNonSolidBlock(NbtDungeonConfig config, BlockState state) {
        if (config.airRequirementIsNowWater) {
            return !state.func_204520_s().func_206888_e();
        }
        return state.func_196958_f();
    }

    private void SetMobSpawnerEntity(Random random, NbtDungeonConfig config, MobSpawnerTileEntity blockEntity) {
        EntityType<?> entity = RepurposedStructures.mobSpawnerManager.getSpawnerMob(config.rsSpawnerResourcelocation, random);
        if (entity != null) {
            blockEntity.func_145881_a().func_200876_a(entity);
        } else {
            RepurposedStructures.LOGGER.warn("EntityType in a dungeon does not exist in registry! : {}", (Object)config.rsSpawnerResourcelocation);
        }
    }

    private void SolidifyBlock(ISeedReader world, BlockPos pos) {
        BlockState blockBelow = world.func_180495_p(pos);
        if (blockBelow.func_235901_b_((Property)SlabBlock.field_196505_a)) {
            world.func_180501_a(pos, (BlockState)blockBelow.func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE), 3);
        }
    }

    private void spawnLootBlocks(ISeedReader world, Random random, BlockPos position, NbtDungeonConfig config, BlockPos fullLengths, BlockPos halfLengths, BlockPos.Mutable mutable) {
        boolean isPlacingChestLikeBlock = config.lootBlock.func_177230_c() instanceof ChestBlock;
        int currentChestAttempt = 0;
        while (currentChestAttempt < config.maxNumOfChests) {
            boolean addedChestThisAttempt = false;
            for (int currentChestPosAttempt = 0; currentChestPosAttempt < fullLengths.func_177958_n() + fullLengths.func_177952_p() + halfLengths.func_177956_o(); ++currentChestPosAttempt) {
                BlockState belowState;
                if (currentChestAttempt == config.maxNumOfChests) {
                    return;
                }
                mutable.func_189533_g((Vector3i)position).func_196234_d(random.nextInt(Math.max(fullLengths.func_177958_n() - 2, 1)) - halfLengths.func_177958_n() + 1, random.nextInt(Math.max(fullLengths.func_177956_o() - 1, 1)), random.nextInt(Math.max(fullLengths.func_177952_p() - 2, 1)) - halfLengths.func_177952_p() + 1);
                BlockState currentBlock = world.func_180495_p((BlockPos)mutable);
                if (!this.isValidNonSolidBlock(config, currentBlock) || !(belowState = world.func_180495_p((BlockPos)mutable.func_189536_c(Direction.DOWN))).func_224755_d((IBlockReader)world, (BlockPos)mutable, Direction.UP) || belowState.func_177230_c() == config.lootBlock.func_177230_c()) continue;
                mutable.func_189536_c(Direction.UP);
                boolean isOnWall = false;
                for (Direction neighborDirection : Direction.Plane.HORIZONTAL) {
                    mutable.func_189536_c(neighborDirection);
                    BlockState neighboringState = world.func_180495_p((BlockPos)mutable);
                    mutable.func_189536_c(neighborDirection.func_176734_d());
                    if (isPlacingChestLikeBlock && neighboringState.func_177230_c() instanceof ChestBlock) {
                        boolean chestTyping;
                        if (neighboringState.func_177229_b((Property)ChestBlock.field_196314_b) != ChestType.SINGLE) continue;
                        BlockState currentStateForChest = GeneralUtils.orientateChest((IServerWorld)world, (BlockPos)mutable, config.lootBlock);
                        Direction currentDirection = (Direction)currentStateForChest.func_177229_b((Property)HorizontalBlock.field_185512_D);
                        if (neighborDirection.func_176740_k() == currentDirection.func_176740_k()) {
                            currentDirection = currentDirection.func_176746_e();
                            BlockPos wallCheckPos = mutable.func_177972_a(currentDirection);
                            BlockPos wallCheckPos2 = wallCheckPos.func_177972_a(neighborDirection);
                            BlockState blockState = world.func_180495_p(wallCheckPos);
                            BlockState blockState2 = world.func_180495_p(wallCheckPos2);
                            if (blockState.func_185904_a().func_76220_a() && !(blockState.func_177230_c() instanceof SpawnerBlock) || blockState2.func_185904_a().func_76220_a() && !(blockState2.func_177230_c() instanceof SpawnerBlock)) {
                                currentDirection = currentDirection.func_176734_d();
                            }
                        }
                        boolean bl = chestTyping = neighborDirection.func_176743_c() == currentDirection.func_176743_c();
                        if (neighborDirection.func_176740_k() == Direction.Axis.Z) {
                            chestTyping = !chestTyping;
                        }
                        world.func_180501_a((BlockPos)mutable, (BlockState)((BlockState)((BlockState)config.lootBlock.func_206870_a((Property)ChestBlock.field_204511_c, (Comparable)Boolean.valueOf(currentBlock.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a)))).func_206870_a((Property)ChestBlock.field_176459_a, (Comparable)currentDirection)).func_206870_a((Property)ChestBlock.field_196314_b, (Comparable)(chestTyping ? ChestType.RIGHT : ChestType.LEFT)), 2);
                        LockableLootTileEntity.func_195479_a((IBlockReader)world, (Random)random, (BlockPos)mutable, (ResourceLocation)config.chestIdentifier);
                        world.func_180501_a((BlockPos)mutable.func_189536_c(neighborDirection), (BlockState)((BlockState)neighboringState.func_206870_a((Property)ChestBlock.field_176459_a, (Comparable)currentDirection)).func_206870_a((Property)ChestBlock.field_196314_b, (Comparable)(chestTyping ? ChestType.LEFT : ChestType.RIGHT)), 2);
                        LockableLootTileEntity.func_195479_a((IBlockReader)world, (Random)random, (BlockPos)mutable, (ResourceLocation)config.chestIdentifier);
                        this.SolidifyBlock(world, mutable.func_177977_b());
                        isOnWall = false;
                        ++currentChestAttempt;
                        addedChestThisAttempt = true;
                        break;
                    }
                    if (!GeneralUtils.isFullCube((IWorldReader)world, (BlockPos)mutable, neighboringState) || neighboringState.func_177230_c() instanceof SpawnerBlock) continue;
                    isOnWall = true;
                }
                if (!isOnWall) continue;
                BlockState lootBlock = config.lootBlock;
                if (lootBlock.func_235901_b_((Property)BlockStateProperties.field_208198_y)) {
                    lootBlock.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(currentBlock.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a)));
                }
                if (lootBlock.func_235901_b_((Property)BlockStateProperties.field_208157_J)) {
                    lootBlock = GeneralUtils.orientateChest((IServerWorld)world, (BlockPos)mutable, lootBlock);
                }
                world.func_180501_a((BlockPos)mutable, lootBlock, 2);
                ++currentChestAttempt;
                addedChestThisAttempt = true;
                LockableLootTileEntity.func_195479_a((IBlockReader)world, (Random)random, (BlockPos)mutable, (ResourceLocation)config.chestIdentifier);
                mutable.func_189536_c(Direction.DOWN);
                if (lootBlock.func_177230_c() == Blocks.field_204409_il && world.func_175625_s((BlockPos)mutable) == null) {
                    world.func_180501_a((BlockPos)mutable, Blocks.field_150474_ac.func_176223_P(), 2);
                    TileEntity blockEntity = world.func_175625_s((BlockPos)mutable);
                    if (!(blockEntity instanceof MobSpawnerTileEntity)) break;
                    this.SetMobSpawnerEntity(random, config, (MobSpawnerTileEntity)blockEntity);
                    break;
                }
                this.SolidifyBlock(world, (BlockPos)mutable);
                break;
            }
            if (addedChestThisAttempt) continue;
            ++currentChestAttempt;
        }
    }
}

